/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.screen.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import com.refinedmods.refinedstorage.api.network.grid.IGridTab;
import com.refinedmods.refinedstorage.apiimpl.render.ElementDrawers;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import com.refinedmods.refinedstorage.util.RenderUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class TabListWidget<T extends AbstractContainerMenu> {
    private final BaseScreen<?> screen;
    private final ElementDrawers<T> drawers;
    private final Supplier<List<IGridTab>> tabs;
    private final int tabsPerPage;
    private final Supplier<Integer> pages;
    private final Supplier<Integer> page;
    private final Supplier<Integer> selected;
    private final List<ITabListListener> listeners = new LinkedList<ITabListListener>();
    private int tabHovering;
    private boolean hadTabs;
    private Button left;
    private Button right;

    public TabListWidget(BaseScreen<T> screen, ElementDrawers<T> drawers, Supplier<List<IGridTab>> tabs, Supplier<Integer> pages, Supplier<Integer> page, Supplier<Integer> selected, int tabsPerPage) {
        this.screen = screen;
        this.drawers = drawers;
        this.tabs = tabs;
        this.pages = pages;
        this.page = page;
        this.selected = selected;
        this.tabsPerPage = tabsPerPage;
    }

    public void init(int width) {
        this.left = this.screen.addButton(this.screen.getGuiLeft(), this.screen.getGuiTop() - 22, 20, 20, (Component)new TextComponent("<"), true, this.pages.get() > 0, btn -> this.listeners.forEach(t -> t.onPageChanged(this.page.get() - 1)));
        this.right = this.screen.addButton(this.screen.getGuiLeft() + width - 22, this.screen.getGuiTop() - 22, 20, 20, (Component)new TextComponent(">"), true, this.pages.get() > 0, btn -> this.listeners.forEach(t -> t.onPageChanged(this.page.get() + 1)));
    }

    public void addListener(ITabListListener listener) {
        this.listeners.add(listener);
    }

    public void drawForeground(PoseStack poseStack, int x, int y, int mouseX, int mouseY, boolean visible) {
        this.tabHovering = -1;
        if (visible) {
            int j = 0;
            for (int i = this.page.get() * this.tabsPerPage; i < this.page.get() * this.tabsPerPage + this.tabsPerPage; ++i) {
                if (i >= this.tabs.get().size()) continue;
                this.drawTab(poseStack, this.tabs.get().get(i), true, x, y, i, j);
                if (RenderUtils.inBounds(x + this.getXOffset() + 29 * j, y, 28, 31 - (i == this.selected.get() ? 2 : 7), mouseX, mouseY)) {
                    this.tabHovering = i;
                }
                ++j;
            }
        }
    }

    public void update() {
        boolean hasTabs;
        boolean bl = hasTabs = !this.tabs.get().isEmpty();
        if (this.hadTabs != hasTabs) {
            this.hadTabs = hasTabs;
            this.screen.m_7856_();
        }
        if (this.page.get() > this.pages.get()) {
            this.listeners.forEach(t -> t.onPageChanged(this.pages.get()));
        }
        this.left.f_93624_ = this.pages.get() > 0;
        this.right.f_93624_ = this.pages.get() > 0;
        this.left.f_93623_ = this.page.get() > 0;
        this.right.f_93623_ = this.page.get() < this.pages.get();
    }

    public void drawBackground(PoseStack poseStack, int x, int y) {
        int j = 0;
        for (int i = this.page.get() * this.tabsPerPage; i < this.page.get() * this.tabsPerPage + this.tabsPerPage; ++i) {
            if (i >= this.tabs.get().size()) continue;
            this.drawTab(poseStack, this.tabs.get().get(i), false, x, y, i, j++);
        }
    }

    public int getHeight() {
        return !this.tabs.get().isEmpty() ? 27 : 0;
    }

    private int getXOffset() {
        if (this.pages.get() > 0) {
            return 24;
        }
        return 0;
    }

    private void drawTab(PoseStack poseStack, IGridTab tab, boolean foregroundLayer, int x, int y, int index, int num) {
        int uvx;
        boolean isSelected;
        boolean bl = isSelected = index == this.selected.get();
        if (foregroundLayer && !isSelected || !foregroundLayer && isSelected) {
            return;
        }
        int tx = x + this.getXOffset() + 29 * num;
        int ty = y;
        this.screen.bindTexture("refinedstorage", "icons.png");
        if (!isSelected) {
            ty += 3;
        }
        int uvy = 225;
        int tbw = 28;
        int otx = tx;
        if (isSelected) {
            uvx = 227;
            if (num > 0 || this.getXOffset() != 0) {
                uvx = 226;
                uvy = 194;
                ++tbw;
                --tx;
            }
        } else {
            uvx = 199;
        }
        this.screen.m_93228_(poseStack, tx, ty, uvx, uvy, tbw, 31);
        tab.drawIcon(poseStack, otx + 6, ty + 9 - (!isSelected ? 3 : 0), this.drawers.getItemDrawer(), this.drawers.getFluidDrawer());
    }

    public void drawTooltip(PoseStack poseStack, Font fontRenderer, int mouseX, int mouseY) {
        if (this.tabHovering >= 0 && this.tabHovering < this.tabs.get().size()) {
            this.tabs.get().get(this.tabHovering).drawTooltip(poseStack, mouseX, mouseY, (Screen)this.screen);
        }
    }

    public boolean mouseClicked() {
        if (this.tabHovering >= 0 && this.tabHovering < this.tabs.get().size()) {
            this.listeners.forEach(t -> t.onSelectionChanged(this.tabHovering));
            return true;
        }
        return false;
    }

    public static interface ITabListListener {
        public void onSelectionChanged(int var1);

        public void onPageChanged(int var1);
    }
}

